/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.urgentpath;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.report.urgentpath.GarPathNode;
import cz.insophy.inplan.report.urgentpath.PathNode;
import cz.insophy.inplan.report.urgentpath.SaPathNode;
import cz.insophy.inplan.report.urgentpath.SrPathNode;
import cz.insophy.inplan.sdgraph.SdgEdge;
import cz.insophy.inplan.sdgraph.SdgGorNode;
import cz.insophy.inplan.sdgraph.SdgNode;
import cz.insophy.inplan.sdgraph.StoreDependencyGraph;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.store.InPlanStoreActivity;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreActivityOwner;
import cz.insophy.inplan.store.TransactionStoreActivity;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.Superplan;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class UrgentPathAnalyzer {
    private final Superplan superplan;
    private final StoreDependencyGraph sdg;
    protected final Ordering<StoreActivity> saOrdering = new Ordering<StoreActivity>(){

        @Override
        public int compare(StoreActivity left, StoreActivity right) {
            int res = Long.compare(UrgentPathAnalyzer.this.getTime(left), UrgentPathAnalyzer.this.getTime(right));
            if (res == 0 && (res = Double.compare(left.getQty(), right.getQty())) == 0 && (res = right.getMaterial().getName().compareTo(left.getMaterial().getName())) == 0) {
                String l = left.getOriginator() == null ? "" : Strings.nullToEmpty(left.getOriginator().toString());
                String r = right.getOriginator() == null ? "" : Strings.nullToEmpty(right.getOriginator().toString());
                res = r.compareTo(l);
            }
            return res;
        }
    }.nullsLast();

    public UrgentPathAnalyzer(Superplan superplan) {
        this.superplan = superplan;
        this.sdg = superplan.getSDGraph();
        Preconditions.checkArgument(GeneralizedRequest.isDateValid(superplan.getFixationDate()));
    }

    public List<PathNode> computeUrgentPath(CustomerRequest cr) {
        GeneralizedActionRequest predGar;
        Preconditions.checkArgument(this.superplan.getCustomerRequests().contains(cr));
        ArrayList<PathNode> urgentPath = Lists.newArrayList();
        GeneralizedActionRequest currentGar = null;
        StoreActivity ssa = this.latestSrcSaToNode(this.sdg.getNode(cr), Predicates.alwaysTrue());
        while ((predGar = UrgentPathAnalyzer.getPredGar(currentGar)) != null || ssa != null) {
            currentGar = predGar == null || ssa != null && predGar.getEndDate() < this.getTime(ssa) ? this.followStoreActivity(urgentPath, ssa) : predGar;
            if (currentGar != null) {
                urgentPath.add(new GarPathNode(currentGar));
                ssa = this.latestSrcSaToGar(currentGar);
            }
            if (currentGar != null) continue;
        }
        return Lists.reverse(urgentPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected GeneralizedActionRequest followStoreActivity(List<PathNode> urgentPath, StoreActivity ssa) {
        if (ssa instanceof ExternalStoreActivity || ssa instanceof TransactionStoreActivity) {
            urgentPath.add(new SaPathNode(ssa));
            return null;
        }
        if (!(ssa instanceof InPlanStoreActivity)) throw new IllegalStateException("Unexpected type of store activity encountered.");
        StoreActivityOwner owner = ((InPlanStoreActivity)ssa).getOwner();
        if (owner instanceof SupplyRequest) {
            urgentPath.add(new SrPathNode((SupplyRequest)owner));
            return null;
        }
        if (owner instanceof ActionActivity) {
            return ((ActionActivity)owner).getGar();
        }
        if (owner instanceof GeneralizedActionRequest) {
            return (GeneralizedActionRequest)owner;
        }
        if (!(owner instanceof RebuildActivity)) throw new IllegalStateException("Unexpected SA owner. " + owner);
        urgentPath.add(new SaPathNode(ssa));
        return null;
    }

    @Nullable
    public static GeneralizedActionRequest getPredGar(@Nullable GeneralizedActionRequest gar) {
        if (gar == null) {
            return null;
        }
        GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor(gar);
        if (gor == null) {
            return null;
        }
        GeneralizedActionRequest predGar = null;
        Iterator<GeneralizedActionRequest> iter = Lists.reverse(gor.getGars()).iterator();
        boolean foundCurrentGar = false;
        while (iter.hasNext()) {
            GeneralizedActionRequest g2 = iter.next();
            if (g2 == gar) {
                foundCurrentGar = true;
                continue;
            }
            if (!foundCurrentGar || !GeneralizedRequest.isDateValid(g2.getEndDate())) continue;
            predGar = g2;
            break;
        }
        return predGar;
    }

    @Nullable
    protected StoreActivity latestSrcSaToGar(final GeneralizedActionRequest gar) {
        SdgGorNode n = this.sdg.getNode((GeneralizedOrderRequest)gar.getParent());
        Predicate<SdgEdge> dstGarFilter = new Predicate<SdgEdge>(){

            @Override
            public boolean apply(SdgEdge ed) {
                StoreActivity dsa = ed.getDestinationStoreActivity();
                if (dsa instanceof InPlanStoreActivity) {
                    StoreActivityOwner owner = ((InPlanStoreActivity)dsa).getOwner();
                    GeneralizedActionRequest dsaGar = null;
                    if (owner instanceof GeneralizedActionRequest) {
                        dsaGar = (GeneralizedActionRequest)owner;
                    } else if (owner instanceof ActionActivity) {
                        dsaGar = ((ActionActivity)owner).getGar();
                    }
                    return gar == dsaGar;
                }
                return false;
            }
        };
        return this.latestSrcSaToNode(n, dstGarFilter);
    }

    @Nullable
    protected StoreActivity latestSrcSaToNode(SdgNode node, Predicate<SdgEdge> filter) {
        StoreActivity lssa = null;
        for (SdgEdge edge : node.getIncomingEdges()) {
            StoreActivity ssa = edge.getSourceStoreActivity();
            if (!filter.apply(edge) || lssa != null && this.saOrdering.compare(ssa, lssa) <= 0) continue;
            lssa = ssa;
        }
        return lssa;
    }

    protected long getTime(StoreActivity sa) {
        long materialHorizon;
        long t = sa.getTime();
        if ((sa.getOriginator() instanceof SupplyRequest || sa instanceof ExternalStoreActivity) && GeneralizedRequest.isDateValid(materialHorizon = sa.getMaterial().getMaterialHorizon())) {
            t = Math.min(t, materialHorizon + this.superplan.getFixationDate());
        }
        return t;
    }
}

